<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

// ########################## Update Moderator Cache ##########################
function update_gallery_mod_cache()
{
	global $DB_site;
	$getmods = $DB_site->query("SELECT * FROM " . TABLE_PREFIX ."adv_gallery_moderator ORDER BY catid, username");
	while ($moderators = $DB_site->fetch_array($getmods))
	{
		$mods[] = $moderators;
	}
	build_datastore('gal_mod_cache', serialize($mods));
	$DB_site->free_result($getmods);
	unset($moderators, $mods);
}

// ######################## Make Category Select Field ########################
function print_category_select($selectname, $selectedid = 0, $nonevalue = 'None', $title = '', $disablecat = false, $nonele = 0, $dowidth = false)
{
	global $catselect, $categorycache;

  echo '<tr class="' . fetch_row_bgclass() . '" valign="top">';
  echo '<td>' . $title . ':</td>';
  echo '<td>';

  echo '<select class="bginput" name="' . $selectname . '" size="1">';
	if ($nonevalue)
	{
	  echo '<option value="' . $nonele . '">' . $nonevalue . '</option>';
	}

	if (empty($catselect))
	{
		$catselect = construct_categories($categorycache, 0, -1);
	}

	foreach ($catselect as $cats)
	{
    $dashes = str_repeat(' &nbsp; &nbsp; ', $cats['level'] - 1);
		$selected = '';
		if ($selectedid == $cats['catid'])
		{
			$selected = 'selected="selected"';
			$class = 'fjsel';
		}
		elseif ($cats['level'] <= 4)
		{
			$class = 'fjdpth' . $cats['level'];
		}
		else
		{
			$class = 'fjdpth';
		}

		$options .= '<option class="' . $class . '" value="' . $cats['catid'] . '" ' . $selected . '>' . $dashes . '' . stripslashes($cats['title']) . '</option>';
	}

	echo $options;

  echo '</select>';
 	echo '</td></tr>';
	unset($options);
}

// ########################### Find Category Children #########################
function fetch_category_children($cat = 0)
{
	global $categorycache;

	$getcatarray = construct_categories($categorycache, $cat, -1);
	$catarray = array();
	$catarray[] = $cat;
	if (!empty($getcatarray))
	{
		foreach ($getcatarray AS $cats)
		{
			$catarray[] = $cats['catid'];
		}
	}
	return $catarray;
}

// ###################### Print Category Permissions Rows #####################
function print_category_perm_rows($catinfo, $cat = 0)
{
	global $counter, $usergroupcache, $vbphrase, $categories, $hasperms;

	if ($catinfo)
	{
		$catarray = array();
		foreach ($catinfo AS $cats)
		{
			if ($cats['parent'] == $cat)
			{
				$counter++;
				$cats['level'] = $counter;

				$categories .= '<ul class="lsq"><li><b>' . $cats['title'] . '</b> <span class="smallfont">( <a href="vba_gallery_admin.php?do=resetperms&amp;catid=' . $cats['catid'] . '">[Reset]</a> <a href="vba_gallery_admin.php?do=denyperms&amp;catid=' . $cats['catid'] . '">[Deny All]</a> )</span></li>';
				$categories .= '<ul class="usergroups">';

				foreach ($usergroupcache AS $group)
				{
					if ($hasperms["$group[usergroupid]"]["$cats[catid]"])
					{
						$categories .= '<li class="col-c">[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
					else if ($hasperms["$group[usergroupid]"]["$cats[parent]"])
					{
						$hasperms["$group[usergroupid]"]["$cats[catid]"] = true;
						$categories .= '<li class="col-i">[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';

					}
					else
					{
						$categories .= '<li>[<a href="vba_gallery_admin.php?do=editcategoryperms&amp;c=' . $cats['catid'] . '&amp;u=' . $group['usergroupid'] . '">' . $vbphrase['edit'] . '</a>] ' . $group['title'] . '</li>';
					}
				}

				$categories .=  '</ul><br />';

				print_category_perm_rows($catinfo, $cats['catid']);
				$categories .=  '</ul>';
				$counter--;
			}
		}
	}
	return $categories;
}

// ######################## Print Permission Rows #############################
function print_permission_rows($category)
{
	global $vbphrase, $perms, $usergroup;

	print_description_row($vbphrase['general_options'], 0, 2, 'thead');
	print_yes_no_row(iif($category, $vbphrase['can_view_gallery'], $vbphrase['can_view_category']), 'usergroup[canviewgallery]', $perms['canviewgallery'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_view_images'], 'usergroup[canviewimages]', $perms['canviewimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['moderate_this_groups_images'], 'usergroup[moderateimages]', $perms['moderateimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['moderate_this_groups_posts'], 'usergroup[moderateposts]', $perms['moderateposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_rate_images'], 'usergroup[canrateimages]', $perms['canrateimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_search_images'], 'usergroup[cansearchimages]', $perms['cansearchimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_send_images_friend'], 'usergroup[cansendimagetofriend]', $perms['cansendimagetofriend'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_create_categories'], 'usergroup[cancreatecategories]', $perms['cancreatecategories'], iif($category, 'js_set_custom();'));

	if ($category)
	{
		print_yes_no_row($vbphrase['can_upload_images'], 'usergroup[canuploadimages]', $perms['canuploadimages'], 'js_set_custom();');
	}
	else
	{
		print_input_row($vbphrase['maxumum_user_categories'], 'usergroup[gallery_maxcats]', $usergroup['gallery_maxcats'], iif($category, 'js_set_custom();'));
	}

	if (!$category)
	{
		print_description_row($vbphrase['uploading_options'], 0, 2, 'thead');
		print_yes_no_row($vbphrase['can_upload_images'], 'usergroup[canuploadimages]', $perms['canuploadimages']);
		print_yes_no_row($vbphrase['can_upload_images_from_server'], 'usergroup[canuploadfromserver]', $perms['canuploadfromserver']);
		print_input_row($vbphrase['space_images_may_consume'], 'usergroup[gallery_maxdiskspace]', $usergroup['gallery_maxdiskspace']);
		print_yes_no_row($vbphrase['can_upload_as_other_users'], 'usergroup[canuploadasuser]', $perms['canuploadasuser']);
	}

	print_description_row($vbphrase['image_editing_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_edit_own_images'], 'usergroup[caneditimages]', $perms['caneditimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_others_images'], 'usergroup[caneditothersimages]', $perms['caneditothersimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_own_images'], 'usergroup[candelete]', $perms['candelete'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_others_images'], 'usergroup[candeleteothers]', $perms['candeleteothers'], iif($category, 'js_set_custom();'));

	print_description_row($vbphrase['posting_options'], 0, 2, 'thead');
	print_yes_no_row($vbphrase['can_view_replies_to_images'], 'usergroup[canviewreplies]', $perms['canviewreplies'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_reply_to_images'], 'usergroup[canreplytoimages]', $perms['canreplytoimages'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_own_posts'], 'usergroup[caneditposts]', $perms['caneditposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_edit_others_posts'], 'usergroup[caneditothersposts]', $perms['caneditothersposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_own_posts'], 'usergroup[candeleteposts]', $perms['candeleteposts'], iif($category, 'js_set_custom();'));
	print_yes_no_row($vbphrase['can_delete_others_posts'], 'usergroup[candeleteothersposts]', $perms['candeleteothersposts'], iif($category, 'js_set_custom();'));

}

// ############################## Orphaned Files ##############################
function fetch_orphaned_files($dirname, $location = '')
{
	global $filenamecache, $folders, $vba_options, $ofiles, $fcount;

	if (is_dir($dirname))
	{
		if ($dh = @opendir($dirname))
		{
			$userid = str_replace('/', '', $location);
			while (($filename = @readdir($dh)) !== false)
			{
				if ($filename != '.' AND $filename != '..' AND $filename != 'index.html')
				{
					$fcount++;
					if (is_dir($dirname . '/' . $filename))
					{
						fetch_orphaned_files($dirname . '/' . $filename, $location . '/' . $filename);
					}
					else
					{
						$ofiles[] = $location . '/' . $filename;
					}
				}
			}
		}
	}
	return $ofiles;
}

?>